local Player = ...
assert(Player);

--[[
old: interoperability with NewPara simfiles
given the following conditions:
1) song is in a certain group
2) song's only difficulty does not match group

display the correct difficulty (group name)

iirc this doesn't matter anymore -aj
]]
local GroupDifficulty = {
	Difficulty_Beginner		= "ParaPara",
	Difficulty_Challenge	= "TechPara",
	Difficulty_Easy			= "TraPara",
----------------------------------------
-- these shouldn't need it but I want to define them anyways.
	Difficulty_Medium		= "",
	Difficulty_Hard			= "",
	Difficulty_Edit			= ""
};

local DifficultyGroup = {
	ParaPara = 0,
	TechPara = 1,
	TraPara = 5
};

local Icon = Def.ActorFrame{};

Icon[#Icon+1] = LoadActor("difficulty 6x1")..{
	Name="MeterFill";
	InitCommand=cmd(pause);
	OnCommand=cmd(playcommand,"Set");
	SetCommand=function(self)
		self:visible(GAMESTATE:IsHumanPlayer(Player));
		local SongOrCourse, Selection;

		if GAMESTATE:IsCourseMode() then
			SongOrCourse = GAMESTATE:GetCurrentCourse()
			if SongOrCourse then
				Selection = GAMESTATE:GetCurrentTrail(Player);
			end;
		else
			SongOrCourse = GAMESTATE:GetCurrentSong()
			if SongOrCourse then
				Selection = GAMESTATE:GetCurrentSteps(Player);
			end;
		end;

		if not Selection then
			self:visible(false);
			return;
		else
			local dc = Selection:GetDifficulty();
			if dc then
				-- set state
				if dc == 'Difficulty_Beginner' then
					self:setstate(0);
				elseif dc == 'Difficulty_Easy' then
					self:setstate(1);
				elseif dc == 'Difficulty_Medium' then
					self:setstate(2);
				elseif dc == 'Difficulty_Hard' then
					self:setstate(3);
				elseif dc == 'Difficulty_Challenge' then
					self:setstate(4);
				elseif dc == 'Difficulty_Edit' then
					self:setstate(5);
				end;

				--[[
				-- NewPara compatibility; always do this last!
				if not GAMESTATE:IsCourseMode() then
					-- by now, we should have the song; the check above took care of it.
					local song = GAMESTATE:GetCurrentSong();
					local songGroup = song:GetGroupName();
					local songSteps = song:GetAllSteps();
					-- should have one chart only in a random difficulty
					-- if difficulty and folder don't match, show folder name.
					if GroupDifficulty[dc] ~= "" then
						if songGroup ~= GroupDifficulty[dc] and #songSteps == 1 then
							self:setstate( DifficultyGroup[songGroup] );
						end;
					else
						-- lol can I fucking do that?
						self:setstate(dc - 1);
					end;
				end;
				--]]

				self:visible(true);
			end;
		end;
	end;
	CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
	CurrentStepsP1ChangedMessageCommand=function(self) if Player == PLAYER_1 then self:playcommand("Set"); end; end;
	CurrentStepsP2ChangedMessageCommand=function(self) if Player == PLAYER_2 then self:playcommand("Set"); end; end;
	CurrentTrailP1ChangedMessageCommand=function(self) if Player == PLAYER_1 then self:playcommand("Set"); end; end;
	CurrentTrailP2ChangedMessageCommand=function(self) if Player == PLAYER_2 then self:playcommand("Set"); end; end;
};

return Icon;